/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/interface.h,v $
 * $Id: interface.h,v 3.3 1999/07/20 21:20:22 heiner Exp $
 *
 *	Message I/O interface to interactive interface
 */

#ifndef CHEST_interface_h_INCLUDED
#define CHEST_interface_h_INCLUDED

#include "board.h"

typedef struct Board64		Board64;
typedef struct gen_msg		gen_msg;
typedef struct cm_mv_dep	cm_mv_dep;
typedef struct cm_mv		cm_mv;
typedef struct cm_mv_list	cm_mv_list;
typedef struct cm_chest_msg	cm_chest_msg;


struct Board64
{
    Field	b64_f[64];
    Colour	b64_tomove;		/* who is to move next */
    Position	b64_ep;			/* possible to beat by e.p. */
    Castle	b64_castle[2];		/* indexed by Colour */
    Position	b64_piece[2*MAX_PIECE];	/* piece list for both colours */
    int8	b64_max_piece[2];	/* filled slots in b_piece */
	/* FFS: */
    int8	b64_cur_piece[2];	/* nonempty slots in b_piece */
    int8	b64_fig_cnt[2][MAX_FIGURES]; /* # of figures by colour & type */
    PieceSet	b64_fig_set[2][MAX_FIGURES]; /* set of figs by colour & type */
};

#define PTP64(pos)	MK_POS64(COL(pos),LIN(pos))

#define MSG_DESC	17		/* File Descriptor for chest output */

#define MAX_MSG_SIZ	10000

/*
 * Message definitions.
 */


struct gen_msg				/* generic message header */
{
    unsigned long	type;
    unsigned long	len;
};


struct cm_mv_dep
{
    unsigned long	type;
    unsigned long	len;
    unsigned long	depth;
    unsigned long	level;
};


struct cm_mv
{
    unsigned long	type;
    unsigned long	len;
    unsigned long	level;
    Board64		b;
    Move 		m;
};


struct cm_mv_list
{
    unsigned long	type;
    unsigned long	len;
    unsigned long	level;
    Board64		b;
    const Movelist*	m_list_base;
    Movelist 		m_list;		/* MUST be last element in struct */
};


struct cm_chest_msg
{
    unsigned long	type;
    unsigned long	len;
    unsigned long	val;
};


/*
 * message types:
 *	from chest to ic
 */

#define CM_MOVE_DEPTH		2
#define CM_MOVE			3
#define CM_MOVE_LIST		4
#define CM_CUR_MOVE_DEPTH	5

/*
 * from ic to chest
 */

#define CM_SKIP			20

#endif	/* CHEST_interface_h_INCLUDED */
